<?php require 'views/layouts/header.php'; ?>

<div class="container mt-4">
    <h2>Relatórios Avançados</h2>

    <div class="row mt-4">
        <!-- Card Total Vendas -->
        <div class="col-md-12 mb-4">
            <div class="card bg-success text-white">
                <div class="card-body">
                    <h5 class="card-title">Faturamento Total</h5>
                    <h2 class="display-4">R$ <?php echo number_format($totalSales ?: 0, 2, ',', '.'); ?></h2>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Vendas por Curso -->
        <div class="col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-header">Top 5 Cursos Mais Vendidos</div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <?php foreach($salesByCourse as $course): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo $course['title']; ?>
                                <span class="badge bg-primary rounded-pill"><?php echo $course['count']; ?> vendas (R$ <?php echo number_format($course['total'], 2, ',', '.'); ?>)</span>
                            </li>
                        <?php endforeach; ?>
                        <?php if(empty($salesByCourse)): ?>
                            <li class="list-group-item text-muted">Nenhuma venda registrada.</li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>

        <!-- Top Professores -->
        <div class="col-md-6 mb-4">
            <div class="card h-100">
                <div class="card-header">Top 5 Professores (Faturamento)</div>
                <div class="card-body">
                    <ul class="list-group list-group-flush">
                        <?php foreach($topTeachers as $teacher): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <?php echo $teacher['name']; ?>
                                <span class="badge bg-success rounded-pill">R$ <?php echo number_format($teacher['total_sales'], 2, ',', '.'); ?></span>
                            </li>
                        <?php endforeach; ?>
                        <?php if(empty($topTeachers)): ?>
                            <li class="list-group-item text-muted">Nenhum dado disponível.</li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Vendas por Mês -->
        <div class="col-md-12 mb-4">
            <div class="card">
                <div class="card-header">Vendas nos Últimos 6 Meses</div>
                <div class="card-body">
                    <div class="table-responsive">
                        <table class="table table-striped">
                            <thead>
                                <tr>
                                    <th>Mês/Ano</th>
                                    <th>Faturamento</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php foreach($salesByMonth as $month): ?>
                                    <tr>
                                        <td><?php echo date('m/Y', strtotime($month['month'] . '-01')); ?></td>
                                        <td>R$ <?php echo number_format($month['total'], 2, ',', '.'); ?></td>
                                    </tr>
                                <?php endforeach; ?>
                                <?php if(empty($salesByMonth)): ?>
                                    <tr><td colspan="2" class="text-center text-muted">Sem vendas no período.</td></tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
