<?php require 'views/layouts/header.php'; ?>

<div class="container-fluid mt-4">
    <div class="d-flex justify-content-between align-items-center mb-4">
        <h2>Gerenciamento de Vendas</h2>
    </div>

    <div class="card shadow-sm">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-hover align-middle">
                    <thead class="table-light">
                        <tr>
                            <th>ID</th>
                            <th>Data</th>
                            <th>Aluno</th>
                            <th>Curso</th>
                            <th>Valor</th>
                            <th>Status</th>
                            <th>Método</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($orders as $order): ?>
                            <tr>
                                <td>#<?php echo $order['id']; ?></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($order['created_at'])); ?></td>
                                <td>
                                    <div class="fw-bold"><?php echo htmlspecialchars($order['user_name']); ?></div>
                                    <div class="small text-muted"><?php echo htmlspecialchars($order['email'] ?? ''); ?></div>
                                </td>
                                <td><?php echo htmlspecialchars($order['course_title']); ?></td>
                                <td>R$ <?php echo number_format($order['amount'], 2, ',', '.'); ?></td>
                                <td>
                                    <?php 
                                    $statusClass = 'secondary';
                                    $statusLabel = 'Desconhecido';
                                    
                                    switch($order['status']) {
                                        case 'approved': $statusClass = 'success'; $statusLabel = 'Aprovado'; break;
                                        case 'pending': $statusClass = 'warning'; $statusLabel = 'Pendente'; break;
                                        case 'rejected': $statusClass = 'danger'; $statusLabel = 'Rejeitado'; break;
                                        case 'refunded': $statusClass = 'dark'; $statusLabel = 'Reembolsado'; break;
                                    }
                                    ?>
                                    <span class="badge bg-<?php echo $statusClass; ?>">
                                        <?php echo $statusLabel; ?>
                                    </span>
                                </td>
                                <td>
                                    <?php if ($order['payment_method'] == 'pix_manual'): ?>
                                        <span class="badge bg-success"><i class="fab fa-pix me-1"></i> Pix Manual</span>
                                    <?php elseif ($order['payment_method'] == 'mercadopago'): ?>
                                        <span class="badge bg-primary"><i class="fas fa-credit-card me-1"></i> MP</span>
                                    <?php else: ?>
                                        <span class="text-muted"><?php echo ucfirst($order['payment_method'] ?? '-'); ?></span>
                                    <?php endif; ?>
                                </td>
                                <td>
                                    <div class="btn-group" role="group">
                                        <?php if ($order['status'] == 'pending' && $order['payment_method'] == 'pix_manual'): ?>
                                            <?php if (!empty($order['receipt_url'])): ?>
                                                <button type="button" class="btn btn-sm btn-info text-white" data-bs-toggle="modal" data-bs-target="#receiptModal<?php echo $order['id']; ?>" title="Ver Comprovante">
                                                    <i class="fas fa-file-invoice"></i>
                                                </button>
                                                
                                                <!-- Modal Comprovante -->
                                                <div class="modal fade" id="receiptModal<?php echo $order['id']; ?>" tabindex="-1" aria-hidden="true">
                                                    <div class="modal-dialog modal-lg">
                                                        <div class="modal-content">
                                                            <div class="modal-header">
                                                                <h5 class="modal-title">Comprovante Pedido #<?php echo $order['id']; ?></h5>
                                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                            </div>
                                                            <div class="modal-body text-center">
                                                                <?php 
                                                                $ext = pathinfo($order['receipt_url'], PATHINFO_EXTENSION);
                                                                if (strtolower($ext) === 'pdf'): 
                                                                ?>
                                                                    <embed src="<?php echo url('uploads/receipts/' . $order['receipt_url']); ?>" width="100%" height="500px" type="application/pdf">
                                                                <?php else: ?>
                                                                    <img src="<?php echo url('uploads/receipts/' . $order['receipt_url']); ?>" class="img-fluid" alt="Comprovante">
                                                                <?php endif; ?>
                                                            </div>
                                                            <div class="modal-footer">
                                                                <a href="<?php echo url('uploads/receipts/' . $order['receipt_url']); ?>" target="_blank" class="btn btn-secondary">
                                                                    <i class="fas fa-download me-1"></i> Baixar
                                                                </a>
                                                                <form action="<?php echo url('admin/approve_order/' . $order['id']); ?>" method="POST" class="d-inline">
                                                                    <button type="submit" class="btn btn-success" onclick="return confirm('Confirmar aprovação e liberar acesso?')">
                                                                        <i class="fas fa-check me-1"></i> Aprovar
                                                                    </button>
                                                                </form>
                                                                <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal<?php echo $order['id']; ?>" data-bs-dismiss="modal">
                                                                    <i class="fas fa-times me-1"></i> Rejeitar
                                                                </button>
                                                            </div>
                                                        </div>
                                                    </div>
                                                </div>
                                                
                                                <!-- Modal Rejeição -->
                                                <div class="modal fade" id="rejectModal<?php echo $order['id']; ?>" tabindex="-1" aria-hidden="true">
                                                    <div class="modal-dialog">
                                                        <div class="modal-content">
                                                            <form action="<?php echo url('admin/reject_order/' . $order['id']); ?>" method="POST">
                                                                <div class="modal-header">
                                                                    <h5 class="modal-title">Rejeitar Pedido #<?php echo $order['id']; ?></h5>
                                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                                </div>
                                                                <div class="modal-body">
                                                                    <div class="mb-3">
                                                                        <label for="reason" class="form-label">Motivo da Rejeição</label>
                                                                        <textarea class="form-control" name="reason" rows="3" required placeholder="Ex: Comprovante ilegível, valor incorreto..."></textarea>
                                                                    </div>
                                                                </div>
                                                                <div class="modal-footer">
                                                                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                                                                    <button type="submit" class="btn btn-danger">Confirmar Rejeição</button>
                                                                </div>
                                                            </form>
                                                        </div>
                                                    </div>
                                                </div>

                                                <form action="<?php echo url('admin/approve_order/' . $order['id']); ?>" method="POST" class="d-inline">
                                                    <button type="submit" class="btn btn-sm btn-success" onclick="return confirm('Confirmar aprovação e liberar acesso?')" title="Aprovar">
                                                        <i class="fas fa-check"></i>
                                                    </button>
                                                </form>
                                                
                                                <button type="button" class="btn btn-sm btn-danger" data-bs-toggle="modal" data-bs-target="#rejectModal<?php echo $order['id']; ?>" title="Rejeitar">
                                                    <i class="fas fa-times"></i>
                                                </button>

                                            <?php else: ?>
                                                <span class="text-muted small">Sem comprovante</span>
                                            <?php endif; ?>

                                        <?php elseif ($order['status'] == 'approved'): ?>
                                            <a href="<?php echo url('admin/refund/' . $order['id']); ?>" 
                                               class="btn btn-sm btn-outline-danger" 
                                               onclick="return confirm('Tem certeza que deseja reembolsar esta compra? O acesso do aluno será revogado.')"
                                               title="Reembolsar">
                                                <i class="fas fa-undo"></i>
                                            </a>
                                        <?php else: ?>
                                            <button class="btn btn-sm btn-outline-secondary" disabled>
                                                <i class="fas fa-ban"></i>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                        <?php if (empty($orders)): ?>
                            <tr><td colspan="8" class="text-center py-4 text-muted">Nenhuma venda encontrada.</td></tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>