<?php require 'views/layouts/header.php'; ?>
<?php $activePage = 'footer_settings'; ?>

<div class="container-fluid">
    <div class="row">
        <?php require 'views/layouts/admin_sidebar.php'; ?>

        <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4 py-4">
            <h2 class="h3 mb-4 text-gray-800">Configurações do Rodapé</h2>

            <!-- Main Config Form (Titles, Contact, WhatsApp) -->
            <form action="<?php echo url('admin/footer_settings'); ?>" method="POST">
                
                <div class="row">
                    <?php for ($i = 1; $i <= 3; $i++): ?>
                    <!-- Coluna <?php echo $i; ?> -->
                    <div class="col-md-4">
                        <div class="card shadow mb-4">
                            <div class="card-header py-3">
                                <h6 class="m-0 font-weight-bold text-primary">Coluna <?php echo $i; ?></h6>
                            </div>
                            <div class="card-body">
                                <div class="mb-3">
                                    <label class="form-label">Título da Seção</label>
                                    <input type="text" class="form-control" name="footer_col<?php echo $i; ?>_title" value="<?php echo htmlspecialchars(get_setting('footer_col'.$i.'_title') ?: ($i==1?'Aprendizado':($i==2?'Institucional':'Informações'))); ?>">
                                </div>
                                
                                <hr>
                                
                                <!-- Links List -->
                                <h6 class="fw-bold text-muted small text-uppercase mb-2">Links Ativos</h6>
                                <div class="list-group mb-3">
                                    <?php if (isset($footerLinks[$i]) && count($footerLinks[$i]) > 0): ?>
                                        <?php foreach ($footerLinks[$i] as $link): ?>
                                        <div class="list-group-item p-2 bg-light border-start-primary">
                                            <div class="d-flex justify-content-between align-items-center mb-1">
                                                <strong><?php echo htmlspecialchars($link['label']); ?></strong>
                                                <div class="btn-group btn-group-sm">
                                                    <button type="button" class="btn btn-info text-white" onclick="editLink(<?php echo $link['id']; ?>, '<?php echo addslashes($link['label']); ?>', '<?php echo addslashes($link['url']); ?>', <?php echo $i; ?>)" title="Editar">
                                                        <i class="fas fa-edit"></i>
                                                    </button>
                                                    <a href="<?php echo url('admin/delete_footer_link/'.$link['id']); ?>" class="btn btn-danger" onclick="return confirm('Excluir este link?')" title="Excluir">
                                                        <i class="fas fa-trash"></i>
                                                    </a>
                                                </div>
                                            </div>
                                            <small class="text-muted d-block text-truncate" style="font-family: monospace;"><?php echo htmlspecialchars($link['url']); ?></small>
                                        </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div class="alert alert-light text-center small text-muted">Nenhum link cadastrado</div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Add/Edit Form Area (Inputs only, submission via JS to hidden form) -->
                        <div class="card shadow mb-4 border-left-success">
                            <div class="card-body bg-light">
                                <h6 class="fw-bold text-success small text-uppercase mb-2" id="form-title-<?php echo $i; ?>"><i class="fas fa-plus-circle me-1"></i>Adicionar Link</h6>
                                
                                <input type="hidden" id="link-id-<?php echo $i; ?>">
                                <div class="mb-2">
                                    <input type="text" class="form-control form-control-sm" id="link-label-<?php echo $i; ?>" placeholder="Nome do Link" required>
                                </div>
                                <div class="mb-2">
                                    <input type="text" class="form-control form-control-sm" id="link-url-<?php echo $i; ?>" placeholder="URL (ex: courses)" required>
                                </div>
                                <div class="d-grid gap-2">
                                    <button type="button" class="btn btn-sm btn-primary" id="btn-save-<?php echo $i; ?>" onclick="submitLink(<?php echo $i; ?>)">Adicionar</button>
                                    <button type="button" class="btn btn-sm btn-secondary d-none" id="btn-cancel-<?php echo $i; ?>" onclick="cancelEdit(<?php echo $i; ?>)">Cancelar</button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endfor; ?>
                </div>

                <!-- Contact & WhatsApp Section -->
                <div class="card shadow mb-4">
                    <div class="card-header py-3">
                        <h6 class="m-0 font-weight-bold text-primary">Dados de Contato e WhatsApp</h6>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="col-md-6">
                                <h6 class="fw-bold">Logo (Texto)</h6>
                                <div class="row">
                                    <div class="col-6 mb-3">
                                        <label class="form-label">Linha 1 (Grande)</label>
                                        <input type="text" class="form-control" name="footer_logo_text_1" value="<?php echo htmlspecialchars(get_setting('footer_logo_text_1') ?: 'CURSOS'); ?>">
                                    </div>
                                    <div class="col-6 mb-3">
                                        <label class="form-label">Linha 2 (Pequena)</label>
                                        <input type="text" class="form-control" name="footer_logo_text_2" value="<?php echo htmlspecialchars(get_setting('footer_logo_text_2') ?: 'ONLINE'); ?>">
                                    </div>
                                </div>

                                <h6 class="fw-bold mt-3">Endereço e Contato</h6>
                                <div class="mb-3">
                                    <label class="form-label">Endereço</label>
                                    <input type="text" class="form-control" name="footer_address" value="<?php echo htmlspecialchars(get_setting('footer_address') ?: 'Rua Fictícia, 50/38. Bairro Centro'); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Cidade/Estado/CEP</label>
                                    <input type="text" class="form-control" name="footer_city_state" value="<?php echo htmlspecialchars(get_setting('footer_city_state') ?: 'São Paulo/SP – Cep: 01000-000'); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Email</label>
                                    <input type="email" class="form-control" name="footer_email" value="<?php echo htmlspecialchars(get_setting('footer_email') ?: 'contato@cursosonline.com.br'); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">CNPJ</label>
                                    <input type="text" class="form-control" name="footer_cnpj" value="<?php echo htmlspecialchars(get_setting('footer_cnpj') ?: '00.000.000/0001-00'); ?>">
                                </div>
                            </div>

                            <div class="col-md-6 border-start">
                                <h6 class="fw-bold">WhatsApp Flutuante</h6>
                                <div class="mb-3 form-check form-switch">
                                    <input class="form-check-input" type="checkbox" id="whatsapp_active" name="whatsapp_active" value="1" <?php echo get_setting('whatsapp_active') ? 'checked' : ''; ?>>
                                    <label class="form-check-label" for="whatsapp_active">Ativar Botão do WhatsApp</label>
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Número (com DDI e DDD)</label>
                                    <input type="text" class="form-control" name="whatsapp_number" placeholder="5511999999999" value="<?php echo htmlspecialchars(get_setting('whatsapp_number')); ?>">
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Mensagem Padrão</label>
                                    <input type="text" class="form-control" name="whatsapp_message" value="<?php echo htmlspecialchars(get_setting('whatsapp_message') ?: 'Olá! Gostaria de mais informações.'); ?>">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="mb-4">
                    <button type="submit" class="btn btn-success btn-lg"><i class="fas fa-save me-2"></i>Salvar Configurações Gerais</button>
                </div>

            </form>
            
            <!-- Hidden Form for Link Saving -->
            <form id="link-form" action="<?php echo url('admin/save_footer_link'); ?>" method="POST" style="display:none;">
                <input type="hidden" name="id" id="hidden-link-id">
                <input type="hidden" name="column_number" id="hidden-link-col">
                <input type="hidden" name="label" id="hidden-link-label">
                <input type="hidden" name="url" id="hidden-link-url">
            </form>

        </main>
    </div>
</div>

<!-- JS for Edit -->
<script>
function editLink(id, label, url, col) {
    document.getElementById('link-id-'+col).value = id;
    document.getElementById('link-label-'+col).value = label;
    document.getElementById('link-url-'+col).value = url;
    document.getElementById('btn-save-'+col).textContent = 'Atualizar Link';
    document.getElementById('btn-save-'+col).classList.remove('btn-primary');
    document.getElementById('btn-save-'+col).classList.add('btn-warning');
    document.getElementById('form-title-'+col).innerHTML = '<i class="fas fa-edit me-1"></i>Editar Link';
    document.getElementById('btn-cancel-'+col).classList.remove('d-none');
}

function cancelEdit(col) {
    document.getElementById('link-id-'+col).value = '';
    document.getElementById('link-label-'+col).value = '';
    document.getElementById('link-url-'+col).value = '';
    document.getElementById('btn-save-'+col).textContent = 'Adicionar Link';
    document.getElementById('btn-save-'+col).classList.add('btn-primary');
    document.getElementById('btn-save-'+col).classList.remove('btn-warning');
    document.getElementById('form-title-'+col).innerHTML = '<i class="fas fa-plus-circle me-1"></i>Adicionar Link';
    document.getElementById('btn-cancel-'+col).classList.add('d-none');
}

function submitLink(col) {
    const id = document.getElementById('link-id-'+col).value;
    const label = document.getElementById('link-label-'+col).value;
    const url = document.getElementById('link-url-'+col).value;
    
    if(!label || !url) {
        alert('Preencha nome e URL');
        return;
    }

    document.getElementById('hidden-link-id').value = id;
    document.getElementById('hidden-link-col').value = col;
    document.getElementById('hidden-link-label').value = label;
    document.getElementById('hidden-link-url').value = url;
    
    document.getElementById('link-form').submit();
}
</script>

<?php require 'views/layouts/footer.php'; ?>
