<?php require 'views/layouts/header.php'; ?>

<div class="container mt-4">
    <nav aria-label="breadcrumb">
        <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo url('admin/users'); ?>">Usuários</a></li>
            <li class="breadcrumb-item active" aria-current="page">Editar Usuário</li>
        </ol>
    </nav>

    <div class="card">
        <div class="card-header">
            Editar Usuário: <?php echo $user['name']; ?>
        </div>
        <div class="card-body">
            <form action="<?php echo url('admin/edit_user/' . $user['id']); ?>" method="POST">
                <div class="mb-3">
                    <label class="form-label">Nome Completo</label>
                    <input type="text" name="name" class="form-control" value="<?php echo $user['name']; ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Email</label>
                    <input type="email" name="email" class="form-control" value="<?php echo $user['email']; ?>" required>
                </div>
                <div class="mb-3">
                    <label class="form-label">Senha (Deixe em branco para manter a atual)</label>
                    <input type="password" name="password" class="form-control" placeholder="Nova senha">
                </div>
                <div class="mb-3">
                    <label class="form-label">Perfil (Role)</label>
                    <select name="role" class="form-select" required>
                        <option value="student" <?php echo $user['role'] == 'student' ? 'selected' : ''; ?>>Aluno</option>
                        <option value="professor" <?php echo $user['role'] == 'professor' ? 'selected' : ''; ?>>Professor</option>
                        <option value="tutor" <?php echo $user['role'] == 'tutor' ? 'selected' : ''; ?>>Tutor</option>
                        <option value="admin" <?php echo $user['role'] == 'admin' ? 'selected' : ''; ?>>Administrador</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                <a href="<?php echo url('admin/users'); ?>" class="btn btn-secondary">Cancelar</a>
            </form>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
