<?php require 'views/layouts/header.php'; ?>
<div class="d-flex">
    <?php require 'views/layouts/admin_sidebar.php'; ?>
    <div class="content p-4 w-100">
        <h2 class="mb-4">Editar Item de Menu</h2>
        
        <form action="<?php echo url('admin/edit_menu_item/' . $item['id']); ?>" method="POST">
            <div class="row">
                <div class="col-md-6">
                    <div class="card border-0 shadow-sm">
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="form-label">Localização</label>
                                <select name="menu_location" class="form-select" required>
                                    <option value="header_main" <?php echo $item['menu_location'] == 'header_main' ? 'selected' : ''; ?>>Cabeçalho Principal (Topo)</option>
                                    <option value="footer_col1" <?php echo $item['menu_location'] == 'footer_col1' ? 'selected' : ''; ?>>Rodapé - Coluna 1</option>
                                    <option value="footer_col2" <?php echo $item['menu_location'] == 'footer_col2' ? 'selected' : ''; ?>>Rodapé - Coluna 2</option>
                                </select>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Rótulo (Texto)</label>
                                <input type="text" name="label" class="form-control" value="<?php echo $item['label']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Link (URL)</label>
                                <input type="text" name="link" class="form-control" value="<?php echo $item['link']; ?>" required>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Ordem de Exibição</label>
                                <input type="number" name="order_index" class="form-control" value="<?php echo $item['order_index']; ?>">
                            </div>
                            <button type="submit" class="btn btn-primary">Salvar Alterações</button>
                            <a href="<?php echo url('admin/menus'); ?>" class="btn btn-secondary">Cancelar</a>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>
<?php require 'views/layouts/footer.php'; ?>