<?php require 'views/layouts/header.php'; ?>

<div class="container mt-4">
    <h2>Gerenciar Tutores - <?php echo $course['title']; ?></h2>
    <a href="<?php echo url('admin/courses'); ?>" class="btn btn-secondary mb-3">Voltar</a>

    <div class="row">
        <!-- Adicionar Tutor -->
        <div class="col-md-6">
            <div class="card mb-4">
                <div class="card-header">Adicionar Tutor</div>
                <div class="card-body">
                    <form action="" method="POST">
                        <input type="hidden" name="add_tutor" value="1">
                        <div class="mb-3">
                            <label for="tutor_id" class="form-label">Selecione o Tutor</label>
                            <select class="form-select" name="tutor_id" required>
                                <option value="">Selecione...</option>
                                <?php foreach($availableTutors as $tutor): ?>
                                    <option value="<?php echo $tutor['id']; ?>"><?php echo $tutor['name']; ?> (<?php echo $tutor['email']; ?>)</option>
                                <?php endforeach; ?>
                            </select>
                        </div>
                        <button type="submit" class="btn btn-primary">Vincular</button>
                    </form>
                    <?php if(empty($availableTutors)): ?>
                        <small class="text-muted mt-2 d-block">Não há tutores disponíveis para vincular.</small>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Tutores Vinculados -->
        <div class="col-md-6">
            <div class="card">
                <div class="card-header">Tutores Vinculados</div>
                <div class="card-body">
                    <ul class="list-group">
                        <?php foreach($linkedTutors as $tutor): ?>
                            <li class="list-group-item d-flex justify-content-between align-items-center">
                                <div>
                                    <strong><?php echo $tutor['name']; ?></strong><br>
                                    <small><?php echo $tutor['email']; ?></small>
                                </div>
                                <form action="" method="POST" onsubmit="return confirm('Remover este tutor do curso?');">
                                    <input type="hidden" name="remove_tutor" value="1">
                                    <input type="hidden" name="tutor_id" value="<?php echo $tutor['id']; ?>">
                                    <button type="submit" class="btn btn-danger btn-sm"><i class="fas fa-trash"></i></button>
                                </form>
                            </li>
                        <?php endforeach; ?>
                        <?php if(empty($linkedTutors)): ?>
                            <li class="list-group-item text-muted">Nenhum tutor vinculado.</li>
                        <?php endif; ?>
                    </ul>
                </div>
            </div>
        </div>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
