<?php require 'views/layouts/header.php'; ?>

<div class="row">
    <div class="col-md-3">
        <div class="list-group">
            <a href="<?php echo url('admin/dashboard'); ?>" class="list-group-item list-group-item-action">Dashboard</a>
            <a href="<?php echo url('admin/users'); ?>" class="list-group-item list-group-item-action">Usuários</a>
            <a href="<?php echo url('admin/courses'); ?>" class="list-group-item list-group-item-action">Cursos</a>
            <a href="<?php echo url('admin/categories'); ?>" class="list-group-item list-group-item-action active">Categorias</a>
            <a href="<?php echo url('admin/reports'); ?>" class="list-group-item list-group-item-action">Relatórios</a>
        </div>
    </div>
    <div class="col-md-9">
        <h2>Gerenciar Categorias</h2>
        
        <?php if (isset($success)): ?>
            <div class="alert alert-success"><?php echo $success; ?></div>
        <?php endif; ?>
        <?php if (isset($error)): ?>
            <div class="alert alert-danger"><?php echo $error; ?></div>
        <?php endif; ?>

        <div class="card mb-4">
            <div class="card-header">Nova Categoria</div>
            <div class="card-body">
                <form action="<?php echo url('admin/categories'); ?>" method="POST" class="row g-3">
                    <div class="col-auto">
                        <label for="name" class="visually-hidden">Nome da Categoria</label>
                        <input type="text" class="form-control" id="name" name="name" placeholder="Nome da Categoria" required>
                    </div>
                    <div class="col-auto">
                        <button type="submit" class="btn btn-primary mb-3">Adicionar</button>
                    </div>
                </form>
            </div>
        </div>

        <table class="table table-striped">
            <thead>
                <tr>
                    <th>ID</th>
                    <th>Nome</th>
                    <th>Slug</th>
                    <th>Ações</th>
                </tr>
            </thead>
            <tbody>
                <?php if (isset($categories) && count($categories) > 0): ?>
                    <?php foreach ($categories as $cat): ?>
                    <tr>
                        <td><?php echo $cat['id']; ?></td>
                        <td><?php echo $cat['name']; ?></td>
                        <td><?php echo $cat['slug']; ?></td>
                        <td>
                            <button class="btn btn-sm btn-danger"><i class="fas fa-trash"></i></button>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                <?php else: ?>
                    <tr>
                        <td colspan="4" class="text-center">Nenhuma categoria cadastrada.</td>
                    </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>
</div>

<?php require 'views/layouts/footer.php'; ?>
