<?php require 'views/layouts/header.php'; ?>
<div class="d-flex">
    <?php require 'views/layouts/admin_sidebar.php'; ?>
    <div class="content p-4 w-100">
        <div class="d-flex justify-content-between align-items-center mb-4">
            <h2>Gerenciar Anúncios</h2>
            <a href="<?php echo url('admin/create_ad'); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> Novo Anúncio</a>
        </div>
        
        <div class="card border-0 shadow-sm">
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover align-middle">
                        <thead>
                            <tr>
                                <th>Imagem</th>
                                <th>Título</th>
                                <th>Localização</th>
                                <th>Link</th>
                                <th>Status</th>
                                <th>Ações</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach($ads as $ad): ?>
                                <tr>
                                    <td>
                                        <img src="<?php echo url('uploads/' . $ad['image']); ?>" style="height: 50px; object-fit: cover;" class="rounded">
                                    </td>
                                    <td><?php echo $ad['title']; ?></td>
                                    <td>
                                        <span class="badge bg-secondary"><?php echo $ad['location']; ?></span>
                                    </td>
                                    <td><a href="<?php echo $ad['link']; ?>" target="_blank" class="text-truncate d-inline-block" style="max-width: 150px;"><?php echo $ad['link']; ?></a></td>
                                    <td>
                                        <?php if($ad['active']): ?>
                                            <span class="badge bg-success">Ativo</span>
                                        <?php else: ?>
                                            <span class="badge bg-danger">Inativo</span>
                                        <?php endif; ?>
                                    </td>
                                    <td>
                                        <a href="<?php echo url('admin/edit_ad/' . $ad['id']); ?>" class="btn btn-sm btn-outline-primary"><i class="fas fa-edit"></i></a>
                                        <a href="<?php echo url('admin/delete_ad/' . $ad['id']); ?>" class="btn btn-sm btn-outline-danger" onclick="return confirm('Tem certeza?');"><i class="fas fa-trash"></i></a>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
<?php require 'views/layouts/footer.php'; ?>
