<?php
require_once 'config/db.php';

try {
    // Tabela Settings
    $pdo->exec("CREATE TABLE IF NOT EXISTS settings (
        id INT AUTO_INCREMENT PRIMARY KEY,
        key_name VARCHAR(50) UNIQUE NOT NULL,
        value TEXT,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
        updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
    )");

    // Inserir configurações padrão se não existirem
    $defaultSettings = [
        'site_name' => 'Cursos Online',
        'site_logo' => '', // Caminho da imagem
        'mp_access_token' => 'TEST-7435905586692224-102213-920f7811776518170258079634281358-256567364',
        'mp_public_key' => 'TEST-21d99905-2f98-4c12-8e11-739327576566',
        'home_banner_text' => 'Matricule-se e escolha seus cursos na Sala Virtual!',
        'home_banner_subtext' => 'Você poderá estudar quantos cursos desejar.',
        'primary_color' => '#0d6efd',
        'secondary_color' => '#ffc107'
    ];

    foreach ($defaultSettings as $key => $value) {
        $stmt = $pdo->prepare("SELECT id FROM settings WHERE key_name = ?");
        $stmt->execute([$key]);
        if (!$stmt->fetch()) {
            $pdo->prepare("INSERT INTO settings (key_name, value) VALUES (?, ?)")->execute([$key, $value]);
        }
    }

    // Tabela Ads
    $pdo->exec("CREATE TABLE IF NOT EXISTS ads (
        id INT AUTO_INCREMENT PRIMARY KEY,
        title VARCHAR(255),
        image VARCHAR(255) NOT NULL,
        link VARCHAR(255),
        location VARCHAR(50) DEFAULT 'home_bottom', -- home_top, home_bottom, sidebar, etc.
        active BOOLEAN DEFAULT 1,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");

    echo "Tabelas 'settings' e 'ads' criadas/atualizadas com sucesso!";

} catch (PDOException $e) {
    die("Erro ao configurar banco de dados: " . $e->getMessage());
}
