<?php
require 'config/db.php';

try {
    // Criar tabela home_buttons
    $pdo->exec("CREATE TABLE IF NOT EXISTS home_buttons (
        id INT AUTO_INCREMENT PRIMARY KEY,
        text VARCHAR(255) NOT NULL,
        icon VARCHAR(50) NOT NULL DEFAULT 'fas fa-star',
        link VARCHAR(255) NOT NULL DEFAULT '#',
        color_class VARCHAR(50) NOT NULL DEFAULT 'btn-outline-primary',
        sort_order INT NOT NULL DEFAULT 0,
        active TINYINT(1) NOT NULL DEFAULT 1,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");

    // Verificar se já existem dados
    $stmt = $pdo->query("SELECT COUNT(*) FROM home_buttons");
    if ($stmt->fetchColumn() == 0) {
        // Inserir dados iniciais baseados no layout atual
        $buttons = [
            [
                'text' => 'Curso de Inglês',
                'icon' => 'fas fa-language',
                'link' => '#',
                'color_class' => 'btn-outline-primary',
                'sort_order' => 1
            ],
            [
                'text' => 'Todos os Cursos',
                'icon' => 'fas fa-star',
                'link' => 'courses', // Assumindo rota interna
                'color_class' => 'btn-outline-warning',
                'sort_order' => 2
            ],
            [
                'text' => 'Plataforma Premium',
                'icon' => 'fas fa-crown',
                'link' => '#',
                'color_class' => 'btn-outline-success',
                'sort_order' => 3
            ]
        ];

        $insert = $pdo->prepare("INSERT INTO home_buttons (text, icon, link, color_class, sort_order) VALUES (:text, :icon, :link, :color_class, :sort_order)");
        
        foreach ($buttons as $btn) {
            $insert->execute($btn);
        }
        echo "Botões iniciais inseridos com sucesso.\n";
    } else {
        echo "Tabela home_buttons já contém dados.\n";
    }

    echo "Tabela home_buttons configurada com sucesso.";

} catch (PDOException $e) {
    die("Erro ao configurar banco de dados: " . $e->getMessage());
}
