<?php
require 'config/config.php';
require 'config/db.php';

try {
    // Create table
    $pdo->exec("CREATE TABLE IF NOT EXISTS footer_links (
        id INT AUTO_INCREMENT PRIMARY KEY,
        column_number INT NOT NULL,
        label VARCHAR(255) NOT NULL,
        url VARCHAR(255) NOT NULL,
        order_index INT DEFAULT 0,
        created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
    )");

    // Check if empty
    $count = $pdo->query("SELECT COUNT(*) FROM footer_links")->fetchColumn();

    if ($count == 0) {
        $links = [
            // Col 1
            [1, 'Cursos Online', 'courses'],
            [1, 'Cursos Grátis', 'courses?price=free'],
            [1, 'Conteúdos Gratuitos', 'blog'],
            [1, 'Blog', 'blog'],
            [1, 'Sugerir novo curso', 'contact'],
            [1, 'Certificados', 'validate_certificate'],
            // Col 2
            [2, 'Sobre Nós', 'page/sobre'],
            [2, 'Como Funciona', 'page/como-funciona'],
            [2, 'Perguntas frequentes', 'page/faq'],
            [2, 'Contato', 'contact'],
            [2, 'Consultar certificados', 'validate_certificate'],
            [2, 'Programa Fidelidade', 'page/fidelidade'],
            // Col 3
            [3, 'Política de Privacidade', 'page/privacidade'],
            [3, 'Responsabilidade Social', 'page/social'],
            [3, 'Motivação para dias difíceis', 'blog/motivacao'],
            [3, 'Mapa do Site', 'sitemap'],
        ];

        $stmt = $pdo->prepare("INSERT INTO footer_links (column_number, label, url, order_index) VALUES (?, ?, ?, ?)");
        
        $i = 0;
        foreach ($links as $link) {
            $stmt->execute([$link[0], $link[1], $link[2], $i++]);
        }
        echo "Tabela footer_links criada e populada com sucesso.";
    } else {
        echo "Tabela footer_links já existe.";
    }

} catch (PDOException $e) {
    echo "Erro: " . $e->getMessage();
}
