<?php
require_once 'config/mercadopago.php';

class MercadoPagoService {
    private $accessToken;

    public function __construct() {
        // Tenta pegar do banco, senão usa do arquivo de config
        $dbToken = function_exists('get_setting') ? get_setting('mp_access_token') : null;
        $this->accessToken = $dbToken ?: MP_ACCESS_TOKEN;
    }

    public function createPreference($item, $payer, $externalReference) {
        $url = "https://api.mercadopago.com/checkout/preferences";

        $data = [
            "items" => [
                [
                    "title" => $item['title'],
                    "quantity" => 1,
                    "currency_id" => "BRL",
                    "unit_price" => (float) $item['price']
                ]
            ],
            "payer" => [
                "name" => $payer['name'],
                "email" => $payer['email']
            ],
            "back_urls" => [
                "success" => MP_BACK_URL_SUCCESS,
                "failure" => MP_BACK_URL_FAILURE,
                "pending" => MP_BACK_URL_PENDING
            ],
            "auto_return" => "approved",
            "external_reference" => $externalReference,
            "notification_url" => MP_NOTIFICATION_URL,
            "payment_methods" => [
                "excluded_payment_types" => [],
                "installments" => 12
            ]
        ];

        return $this->post($url, $data);
    }

    public function getPayment($id) {
        $url = "https://api.mercadopago.com/v1/payments/" . $id;
        return $this->get($url);
    }

    private function post($url, $data) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($data));
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Authorization: Bearer " . $this->accessToken
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode >= 200 && $httpCode < 300) {
            return json_decode($response, true);
        } else {
            // Log de erro (simples)
            error_log("Erro Mercado Pago POST: " . $response);
            return null;
        }
    }

    private function get($url) {
        $ch = curl_init($url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_HTTPHEADER, [
            "Content-Type: application/json",
            "Authorization: Bearer " . $this->accessToken
        ]);

        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);

        if ($httpCode >= 200 && $httpCode < 300) {
            return json_decode($response, true);
        } else {
            error_log("Erro Mercado Pago GET: " . $response);
            return null;
        }
    }

    public function refundPayment($id) {
        $url = "https://api.mercadopago.com/v1/payments/" . $id . "/refunds";
        // Para reembolso total, body vazio ou null é suficiente.
        // Para parcial, enviar 'amount'. Vamos assumir total.
        return $this->post($url, null);
    }
}
