<?php
// router.php para servidor embutido do PHP

$path = parse_url($_SERVER["REQUEST_URI"], PHP_URL_PATH);
$ext = pathinfo($path, PATHINFO_EXTENSION);

// Se for arquivo estático existente, serve ele
if (file_exists(__DIR__ . $path) && $ext != 'php' && $ext != '') {
    return false;
}

// Simular o comportamento do .htaccess
// Pega o caminho relativo da base, remove a barra inicial
$scriptName = dirname($_SERVER['SCRIPT_NAME']);
$url = substr($_SERVER['REQUEST_URI'], strlen($scriptName));
$url = ltrim($url, '/');

// Remove 'cursosonline' prefix if present (common when switching from XAMPP to php -S)
$url = preg_replace('#^cursosonline(/|$)#', '', $url);

// Se tiver query string, remove
if (($pos = strpos($url, '?')) !== false) {
    $url = substr($url, 0, $pos);
}

$_GET['url'] = $url;

require __DIR__ . '/index.php';
