<?php
class Course {
    private $pdo;

    public function __construct() {
        global $pdo;
        $this->pdo = $pdo;
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT c.*, u.name as teacher_name, cat.name as category_name 
                                   FROM courses c 
                                   JOIN users u ON c.teacher_id = u.id 
                                   LEFT JOIN categories cat ON c.category_id = cat.id 
                                   ORDER BY c.created_at DESC");
        return $stmt->fetchAll();
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT c.*, u.name as teacher_name, cat.name as category_name 
                                     FROM courses c 
                                     JOIN users u ON c.teacher_id = u.id 
                                     LEFT JOIN categories cat ON c.category_id = cat.id 
                                     WHERE c.id = :id");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch();
    }

    public function create($data) {
        // Handle optional duration
        $duration = isset($data['duration']) ? $data['duration'] : '20 à 40 Horas';
        $data['duration'] = $duration;

        // Ensure new fields are present or null
        $data['what_will_i_learn'] = isset($data['what_will_i_learn']) ? $data['what_will_i_learn'] : null;
        $data['target_audience'] = isset($data['target_audience']) ? $data['target_audience'] : null;
        $data['requirements'] = isset($data['requirements']) ? $data['requirements'] : null;

        $sql = "INSERT INTO courses (teacher_id, title, slug, description, price, category_id, status, image, duration, what_will_i_learn, target_audience, requirements) 
                VALUES (:teacher_id, :title, :slug, :description, :price, :category_id, :status, :image, :duration, :what_will_i_learn, :target_audience, :requirements)";
        $stmt = $this->pdo->prepare($sql);
        return $stmt->execute($data);
    }

    public function getModules($courseId) {
        $stmt = $this->pdo->prepare("SELECT * FROM modules WHERE course_id = :course_id ORDER BY position ASC");
        $stmt->execute(['course_id' => $courseId]);
        return $stmt->fetchAll();
    }
}
