<?php
class ProfileController {
    public function __construct() {
        if (!isLoggedIn()) {
            redirect('login');
        }
    }

    public function index() {
        global $pdo;
        $userId = $_SESSION['user_id'];
        
        // Processar atualização
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $name = $_POST['name'];
            $email = $_POST['email'];
            $password = $_POST['password'];
            $confirmPassword = $_POST['confirm_password'];

            $errors = [];

            // Validações básicas
            if (empty($name) || empty($email)) {
                $errors[] = "Nome e Email são obrigatórios.";
            }

            if (!empty($password)) {
                if ($password !== $confirmPassword) {
                    $errors[] = "As senhas não conferem.";
                }
            }

            if (empty($errors)) {
                // Verificar se email já existe (excluindo o próprio usuário)
                $stmt = $pdo->prepare("SELECT id FROM users WHERE email = :email AND id != :id");
                $stmt->execute(['email' => $email, 'id' => $userId]);
                if ($stmt->rowCount() > 0) {
                    $errors[] = "Este email já está em uso.";
                } else {
                    // Atualizar
                    $sql = "UPDATE users SET name = :name, email = :email";
                    $params = ['name' => $name, 'email' => $email, 'id' => $userId];

                    if (!empty($password)) {
                        $sql .= ", password = :password";
                        $params['password'] = password_hash($password, PASSWORD_DEFAULT);
                    }

                    // Upload de Avatar
                    if (isset($_FILES['avatar']) && $_FILES['avatar']['error'] === 0) {
                        $allowed = ['jpg', 'jpeg', 'png', 'gif'];
                        $ext = strtolower(pathinfo($_FILES['avatar']['name'], PATHINFO_EXTENSION));
                        
                        if (in_array($ext, $allowed)) {
                            $newFilename = 'avatar_' . $userId . '_' . time() . '.' . $ext;
                            $uploadDir = 'uploads/';
                            
                            if (move_uploaded_file($_FILES['avatar']['tmp_name'], $uploadDir . $newFilename)) {
                                $sql .= ", avatar = :avatar";
                                $params['avatar'] = $newFilename;
                                
                                // Opcional: Remover avatar antigo se existir
                                $stmtOld = $pdo->prepare("SELECT avatar FROM users WHERE id = :id");
                                $stmtOld->execute(['id' => $userId]);
                                $oldAvatar = $stmtOld->fetchColumn();
                                if ($oldAvatar && file_exists($uploadDir . $oldAvatar)) {
                                    @unlink($uploadDir . $oldAvatar);
                                }
                            } else {
                                $errors[] = "Erro ao fazer upload da imagem.";
                            }
                        } else {
                            $errors[] = "Formato de imagem inválido. Use JPG, PNG ou GIF.";
                        }
                    }

                    if (empty($errors)) {
                        $sql .= " WHERE id = :id";
                        $stmt = $pdo->prepare($sql);
                        if ($stmt->execute($params)) {
                            // Atualizar sessão
                            $_SESSION['user_name'] = $name;
                            $success = "Perfil atualizado com sucesso!";
                        } else {
                            $errors[] = "Erro ao atualizar perfil.";
                        }
                    }
                }
            }
        }

        // Buscar dados atuais
        $stmt = $pdo->prepare("SELECT * FROM users WHERE id = :id");
        $stmt->execute(['id' => $userId]);
        $user = $stmt->fetch();

        require 'views/profile/index.php';
    }
}
