<?php
class CourseController {
    
    public function index() {
        $courseModel = new Course();
        global $pdo;
        
        $categoryId = isset($_GET['category']) ? $_GET['category'] : null;
        
        if ($categoryId) {
            $stmt = $pdo->prepare("SELECT c.*, u.name as teacher_name, cat.name as category_name 
                                   FROM courses c 
                                   JOIN users u ON c.teacher_id = u.id 
                                   LEFT JOIN categories cat ON c.category_id = cat.id 
                                   WHERE c.category_id = :cat_id AND c.status = 'published'
                                   ORDER BY c.created_at DESC");
            $stmt->execute(['cat_id' => $categoryId]);
            $courses = $stmt->fetchAll();
        } else {
            // Se não filtrar, usa o método do model (que pega todos, vamos filtrar published aqui se necessário ou ajustar model)
            // O model getAll pega todos. Vamos fazer uma query específica aqui para garantir status published na home pública
            $stmt = $pdo->query("SELECT c.*, u.name as teacher_name, cat.name as category_name 
                                   FROM courses c 
                                   JOIN users u ON c.teacher_id = u.id 
                                   LEFT JOIN categories cat ON c.category_id = cat.id 
                                   WHERE c.status = 'published'
                                   ORDER BY c.created_at DESC");
            $courses = $stmt->fetchAll();
        }

        // Buscar categorias para o filtro
        $categories = $pdo->query("SELECT * FROM categories ORDER BY name ASC")->fetchAll();

        require 'views/courses/index.php';
    }

    public function show($id) {
        if (!$id) {
            redirect('courses');
        }

        $courseModel = new Course();
        $course = $courseModel->getById($id);

        if (!$course) {
            echo "Curso não encontrado.";
            return;
        }

        // Buscar módulos e aulas para o Conteúdo Programático
        $modules = $courseModel->getModules($id);
        global $pdo;
        foreach ($modules as &$mod) {
            $stmt = $pdo->prepare("SELECT * FROM lessons WHERE module_id = :mid ORDER BY position ASC");
            $stmt->execute(['mid' => $mod['id']]);
            $mod['lessons'] = $stmt->fetchAll();
        }

        // Buscar Avaliações
        $stmt = $pdo->prepare("SELECT r.*, u.name as user_name FROM reviews r JOIN users u ON r.user_id = u.id WHERE r.course_id = :cid ORDER BY r.created_at DESC");
        $stmt->execute(['cid' => $id]);
        $reviews = $stmt->fetchAll();

        require 'views/courses/show.php';
    }

    public function buy($id) {
        if (!isLoggedIn()) {
            $_SESSION['redirect_after_login'] = 'course/buy/' . $id;
            redirect('login');
        }

        $courseModel = new Course();
        $course = $courseModel->getById($id);

        // Integração Mercado Pago (Simulação)
        // Aqui você criaria a preferência de pagamento via API do MP
        
        // Simular criação de pedido
        global $pdo;
        $stmt = $pdo->prepare("INSERT INTO orders (user_id, course_id, amount, status, payment_method) VALUES (:uid, :cid, :amount, 'pending', 'mercadopago')");
        $stmt->execute([
            'uid' => $_SESSION['user_id'],
            'cid' => $id,
            'amount' => $course['price']
        ]);
        
        $orderId = $pdo->lastInsertId();

        // Redirecionar para página de checkout ou gateway
        // Como não temos credenciais reais, vamos simular uma tela de pagamento
        require 'views/courses/checkout.php';
    }
}
